<?php
header('Content-Type: application/json; charset=utf-8');
include 'db_connect.php'; // make sure this connects to your database

$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

// Input values
$user_id           = intval($_POST['user_id'] ?? 0);
$product_id        = intval($_POST['product_id'] ?? 0);
$product_name      = trim($_POST['product_name'] ?? '');
$product_price     = floatval($_POST['product_price'] ?? 0);
$quantity          = intval($_POST['quantity'] ?? 0);
$total_price       = floatval($_POST['total_price'] ?? 0);
$total_earning     = floatval($_POST['total_earning'] ?? 0);
$total_product_price     = floatval($_POST['total_product_price'] ?? 0);
$delivery_charge   = floatval($_POST['delivery_charge'] ?? 0);
$customer_name     = trim($_POST['customer_name'] ?? '');
$customer_number   = trim($_POST['customer_number'] ?? '');
$customer_address  = trim($_POST['customer_address'] ?? '');
$account_number    = trim($_POST['account_number'] ?? '');
$transaction_id    = trim($_POST['transaction_id'] ?? '');
$amount            = floatval($_POST['amount'] ?? 0);
$payment_gateway   = trim($_POST['payment_gateway'] ?? '');
$current_time = date("Y-m-d H:i:s");
$current_time2 = date("d-m-Y H:i A");

// Basic validation
if (
    $user_id <= 0 || 
    $product_id <= 0 || 
    empty($product_name) || 
    $product_price <= 0 || 
    empty($customer_name) || 
    empty($customer_number)
) {
    echo json_encode([
        'success' => false,
        'message' => 'Required fields are missing or invalid.'
    ]);
    exit;
}

// Insert query
$sql = "INSERT INTO orders (
            user_id, product_id, product_name, product_price, customer_name, customer_number,
            quantity, total_price, total_earning, total_product_price, delivery_charge,
            customer_address, account_number, transaction_id, payment_gateway, amount, created_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "iisdssiddddssssds",
    $user_id,
    $product_id,
    $product_name,
    $product_price,
    $customer_name,
    $customer_number,
    $quantity,
    $total_price,
    $total_earning,
    $total_product_price,
    $delivery_charge,
    $customer_address,
    $account_number,
    $transaction_id,
    $payment_gateway,
    $amount,
    $current_time
);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Order submitted successfully.'
    ]);

    $insert = $conn->prepare("INSERT INTO transactions (user_id, amount, payment_gateway, type, description, update_at) VALUES (?, ?, 'Reselling Advance', 'payment', 'Payment For Reselling', ?)");
    $insert->bind_param("ids", $user_id, $delivery_charge, $current_time2);
    $insert->execute();

} else {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to submit order.',
        'error' => $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
