<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'db_connect.php';
$conn->set_charset('utf8mb4');

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!isset($data['job_id']) || !isset($data['user_id']) || !isset($data['message'])) {
    echo json_encode(["success" => false, "message" => "Required parameters missing."]);
    exit;
}

$job_id = $data['job_id'];
$worker_user_id = $data['user_id'];
$proof_message = $data['message'];
$date = date("Y-m-d H:i:s");

// check if already submitted
$check = $conn->prepare("SELECT * FROM microjob_submissions WHERE job_id=? AND worker_user_id=?");
$check->bind_param("ii", $job_id, $worker_user_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    echo json_encode(["success" => false, "message" => "You already submitted proof for this job."]);
    exit;
}

// check job target
$job_check = $conn->prepare("SELECT remaining_target FROM microjobs WHERE id=?");
$job_check->bind_param("i", $job_id);
$job_check->execute();
$job_result = $job_check->get_result();
$job = $job_result->fetch_assoc();

if ($job['remaining_target'] <= 0) {
    echo json_encode(["success" => false, "message" => "Job target reached!"]);
    exit;
}

$proof_image = '';
if (!empty($_FILES['proof_image']['name'])) {
    // Validate file type
    $allowed_types = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif'];
    $file_type = $_FILES['proof_image']['type'];

    if (!in_array($file_type, $allowed_types)) {
        echo json_encode(["success" => false, "message" => "Invalid file type. Only JPG, PNG, and GIF are allowed."]);
        exit;
    }

    // Generate unique file name
    $proof_image = time() . '_' . $_FILES['proof_image']['name'];

    // Move the uploaded file
    if (!move_uploaded_file($_FILES['proof_image']['tmp_name'], "ProofImage/" . $proof_image)) {
        echo json_encode(["success" => false, "message" => "Failed to upload proof image."]);
        exit;
    }
}

// insert submission
$stmt = $conn->prepare("INSERT INTO microjob_submissions (job_id, worker_user_id, proof_message, proof_image, status, created_at) VALUES (?, ?, ?, ?, 'pending', ?)");
$stmt->bind_param("iisss", $job_id, $worker_user_id, $proof_message, $proof_image, $date);
$submitted = $stmt->execute();

if ($submitted) {
    // decrease job target
    $conn->query("UPDATE microjobs SET remaining_target = remaining_target - 1 WHERE id='$job_id'");
    echo json_encode(["success" => true, "message" => "Proof submitted successfully!"]);
} else {
    echo json_encode(["success" => false, "message" => "Failed to submit proof."]);
}
?>
