<?php
header("Content-Type: application/json");
$response = array();

include 'db_connect.php'; // Make sure this file contains your DB connection
$conn->set_charset("utf8mb4");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['user_id'] ?? null;
    $refer_id = $_POST['refer_id'] ?? null;
    $job_id = $_POST['job_id'] ?? null;
    $message = $_POST['message'] ?? '';
    $number = $_POST['number'] ?? '';

    if (!$user_id || !$refer_id || !$job_id || empty($message) || empty($number)) {
        $response['status'] = 'fail';
        $response['message'] = 'Missing required fields!';
        echo json_encode($response);
        exit;
    }

    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $targetDir = "reviewJobImage/";
        if (!file_exists($targetDir)) {
            mkdir($targetDir, 0755, true);
        }

        $fileExt = pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION);
        $fileName = uniqid("proof_", true) . "." . $fileExt;
        $targetFilePath = $targetDir . $fileName;

        if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
            $image_url = $targetFilePath;

            // ✅ Insert into review_submissions table
            $stmt = $conn->prepare("INSERT INTO review_submissions (job_id, refer_id, worker_user_id, proof_image_url, proof_message, number, status) VALUES (?, ?, ?, ?, ?, ?, 'pending')");
            $stmt->bind_param("iiisss", $job_id, $refer_id, $user_id, $image_url, $message, $number);

            if ($stmt->execute()) {
                $response['status'] = 'success';
                $response['message'] = 'Proof uploaded and saved successfully!';
            } else {
                $response['status'] = 'fail';
                $response['message'] = 'Database error: ' . $conn->error;
            }

            $stmt->close();
        } else {
            $response['status'] = 'fail';
            $response['message'] = 'Failed to move uploaded file!';
        }
    } else {
        $response['status'] = 'fail';
        $response['message'] = 'No image uploaded or upload error!';
    }
} else {
    $response['status'] = 'fail';
    $response['message'] = 'Invalid request method!';
}

echo json_encode($response);
?>
