<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_POST['user_id'] ?? null;
$refer_id = $_POST['refer_id'] ?? null;
$account_number = $_POST['account_number'] ?? null;
$transaction_id = $_POST['transaction_id'] ?? null;
$amount = $_POST['amount'] ?? null;
$payment_gateway = $_POST['payment_gateway'] ?? null;
$current_time = $_POST['current_time'] ?? date("Y-m-d H:i:s"); // Default: Current time

$response = [];

if (isset($user_id) && isset($account_number) && isset($transaction_id) && isset($amount)) {

    // Check if this transaction_id is already used in an approved request
    $check_txn = $conn->prepare("SELECT id FROM verification_requests WHERE transaction_id = ? AND status = 'Approved'");
    $check_txn->bind_param("s", $transaction_id);
    $check_txn->execute();
    $check_txn_result = $check_txn->get_result();

    if ($check_txn_result->num_rows > 0) {
        $response['message'] = "⚠️ এই ট্রানজেকশন আইডি ইতোমধ্যে ব্যবহৃত হয়েছে। অনুগ্রহ করে একটি বৈধ ট্রানজেকশন আইডি দিন।";
        echo json_encode($response);
        exit;
    }


    // ইউজারের ভেরিফিকেশন স্ট্যাটাস চেক করুন
    $query = "SELECT is_verified FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

        // Send verification request
        $query = "UPDATE sign_up SET is_verified = 2 WHERE id = ?"; // Set status to pending
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $user_id);

        if ($stmt->execute()) {
            $response['message'] = "ভেরিফিকেশন রিকুয়েস্ট সফলভাবে পাঠানো হয়েছে";
        } else {
            $response['message'] = "ভেরিফিকেশন রিকুয়েস্ট পাঠানো ব্যর্থ";
        }

        if ($user['is_verified'] == 0) {
            // ভেরিফিকেশন রিকোয়েস্ট সাবমিট করুন
            $insert_query = "INSERT INTO verification_requests (user_id, refer_id, account_number, transaction_id, amount, payment_gateway, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($insert_query);
            $stmt->bind_param("isssdss", $user_id, $refer_id, $account_number, $transaction_id, $amount, $payment_gateway, $current_time);

            if ($stmt->execute()) {
                $response['message'] = "ভেরিফিকেশন রিকোয়েস্ট সফলভাবে সাবমিট হয়েছে";
            } else {
                $response['message'] = "ভেরিফিকেশন রিকোয়েস্ট সাবমিট করা ব্যর্থ হয়েছে";
            }
        } else {
            $response['message'] = "ইউজার ইতিমধ্যে ভেরিফাইড";
        }
    } else {
        $response['message'] = "ইউজার খুঁজে পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>