<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_POST['user_id'] ?? null;
$file = $_FILES['file'] ?? null;

$response = [];

if (isset($user_id) && isset($file)) {
    $targetDir = "Images/"; // Folder to store profile pictures
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    // Check if the user already has a profile picture
    $query = "SELECT profile_pic_url FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $oldProfilePicUrl = $row['profile_pic_url'];

        // Delete the old profile picture file from the server (if it exists)
        if (!empty($oldProfilePicUrl)) {
            $oldFilePath = parse_url($oldProfilePicUrl, PHP_URL_PATH);
            $oldFilePath = ltrim($oldFilePath, '/');
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath); // Delete the old file
            }
        }
    }

    // Generate a unique file name
    $fileExtension = pathinfo($file["name"], PATHINFO_EXTENSION); // Get file extension
    $fileName = uniqid('profile_', true) . "." . $fileExtension; // Random file name like "profile_abc123.jpg"
    $targetFilePath = $targetDir . $fileName;

    // Allow certain file formats
    $allowTypes = ['jpg', 'png', 'jpeg'];
    if (in_array($fileExtension, $allowTypes)) {
        if (move_uploaded_file($file["tmp_name"], $targetFilePath)) {
            // Update profile_pic_url in the database
            $profilePicUrl = "https://mrdeveloper.xyz/Rootva/$targetFilePath";
            $query = "UPDATE sign_up SET profile_pic_url = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("si", $profilePicUrl, $user_id);

            if ($stmt->execute()) {
                $response['message'] = $profilePicUrl; // Return the new URL
            } else {
                $response['message'] = "ডেটা আপডেট ব্যর্থ";
            }
        } else {
            $response['message'] = "ছবি আপলোড ব্যর্থ";
        }
    } else {
        $response['message'] = "অনুমোদিত ফাইল ফরম্যাট নয়";
    }
} else {
    $response['message'] = "অবৈধ ডেটা";
}

echo json_encode($response);
?>