<?php
include 'db_connect.php';
$conn->set_charset("utf8mb4");
header("Content-Type: application/json; charset=utf-8");

$user_id = $_POST['user_id'] ?? null;
$payment_amount = $_POST['amount'] ?? null;

$response = [];

if (isset($user_id) && isset($payment_amount) && $payment_amount == 230) {
    // ভেরিফিকেশন চেক
    $query = "SELECT is_verified FROM sign_up WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

        if ($user['is_verified'] == 0) {
            // ভেরিফিকেশন আপডেট করুন
            $update_query = "UPDATE sign_up SET is_verified = 1 WHERE id = ?";
            $stmt = $conn->prepare($update_query);
            $stmt->bind_param("i", $user_id);

            if ($stmt->execute()) {
                // ট্রানজেকশন রেকর্ড করুন
                $description = "User verified with payment of $payment_amount";
                $insert_transaction = "INSERT INTO transactions (user_id, amount, type, description) VALUES (?, ?, 'verification', ?)";
                $stmt = $conn->prepare($insert_transaction);
                $stmt->bind_param("ids", $user_id, $payment_amount, $description);
                $stmt->execute();

                $response['message'] = "ভেরিফিকেশন সফল";
            } else {
                $response['message'] = "ভেরিফিকেশন ব্যর্থ";
            }
        } else {
            $response['message'] = "ইউজার ইতিমধ্যে ভেরিফাইড";
        }
    } else {
        $response['message'] = "ইউজার খুঁজে পাওয়া যায়নি";
    }
} else {
    $response['message'] = "অবৈধ ডেটা বা ভুল পরিমাণ টাকা";
}

echo json_encode($response);
?>