<?php
error_reporting(E_ALL);
ini_set('display_errors',1);
include 'db_connect.php';
$conn->set_charset("utf8mb4");
date_default_timezone_set("Asia/Dhaka");

// সপ্তাহের হিসাব
$today = date("Y-m-d");
$startOfWeek = date("Y-m-d", strtotime("last saturday", strtotime($today)));
$endOfWeek = date("Y-m-d", strtotime("next friday", strtotime($startOfWeek)));

$startTime = $startOfWeek . " 00:00:00";
$endTime = $endOfWeek . " 23:59:59";

$query = "
    SELECT 
        s.referredBy AS refer_id, 
        r.id AS user_id, 
        r.name, 
        r.profile_pic_url, 
        COUNT(*) AS total
    FROM verification_requests vr
    JOIN sign_up s ON vr.user_id = s.id
    JOIN sign_up r ON s.referredBy = r.referCode
    WHERE vr.status = 'Approved'
      AND vr.verified_raw_time BETWEEN ? AND ?
    GROUP BY s.referredBy
    HAVING total >= 20
    ORDER BY total DESC
    LIMIT 1
";

$stmt = $conn->prepare($query);

if (!$stmt) {
    die("Query Prepare Failed: " . $conn->error);
}

$stmt->bind_param("ss", $startOfWeek, $endOfWeek);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $user_id = $row['user_id'];
    $refer_id = $row['refer_id'];
    $total = $row['total'];

    $amount = 1000.00;
    $type = 'income';
    $payment_gateway = 'Weekly Bonus';
    $description = "🎉 Weekly Winner Bonus for $total verifications on $date";
    $created_at = date("Y-m-d H:i:s");
    $update_at = $created_at;

    $insert = $conn->prepare("INSERT INTO transactions (user_id, refer_id, amount, type, payment_gateway, description, update_at, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $insert->bind_param("isdsssss", $user_id, $refer_id, $amount, $type, $payment_gateway, $description, $update_at, $created_at);
    $insert->execute();

    // Insert into bonus_tracker
    $bonus_insert = $conn->prepare("INSERT INTO bonus_tracker (user_id, bonus_type, amount, created_at) VALUES (?, 'weekly_bonus', ?, ?)");
    $bonus_insert->bind_param("ids", $user_id, $amount, $created_at);
    $bonus_insert->execute();

    echo "✅ Bonus transaction added for User ID: $user_id with $total verifications.";
} else {
    echo "⚠️ No user verified 20 or more accounts previous week.";
}
?>
